/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundOpenScreenPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySongNotesPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySpeakerMessagePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendKnockbackPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendLoginPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSetSongPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSpawnBlockParticlePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncAntiqueInk;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncGlobeDataPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncSongsPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncTradesPacket;
import net.mehvahdjukaar.supplementaries.common.network.OpenConfigsPacket;
import net.mehvahdjukaar.supplementaries.common.network.PicklePacket;
import net.mehvahdjukaar.supplementaries.common.network.RequestConfigReloadPacket;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundCycleQuiverPacket;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundRequestMapDataPacket;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSelectMerchantTradePacket;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetBlackboardPacket;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetPresentPacket;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetSpeakerBlockPacket;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetTextHolderPacket;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetTrappedPresentPacket;
import net.mehvahdjukaar.supplementaries.common.network.SyncConfigsPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

public class NetworkHandler {
    public static SimpleChannel INSTANCE;
    private static int ID;
    private static final String PROTOCOL_VERSION = "1";

    private static <MSG> void register(Class<MSG> messageClass, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        INSTANCE.registerMessage(ID++, messageClass, encoder, decoder, messageConsumer);
    }

    public static void registerMessages() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)Supplementaries.res("network"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        NetworkHandler.register(ClientBoundPlaySpeakerMessagePacket.class, ClientBoundPlaySpeakerMessagePacket::buffer, ClientBoundPlaySpeakerMessagePacket::new, ClientBoundPlaySpeakerMessagePacket::handler);
        NetworkHandler.register(ServerBoundSetSpeakerBlockPacket.class, ServerBoundSetSpeakerBlockPacket::buffer, ServerBoundSetSpeakerBlockPacket::new, ServerBoundSetSpeakerBlockPacket::handler);
        NetworkHandler.register(ServerBoundSetTextHolderPacket.class, ServerBoundSetTextHolderPacket::buffer, ServerBoundSetTextHolderPacket::new, ServerBoundSetTextHolderPacket::handler);
        NetworkHandler.register(ClientBoundSyncGlobeDataPacket.class, ClientBoundSyncGlobeDataPacket::buffer, ClientBoundSyncGlobeDataPacket::new, ClientBoundSyncGlobeDataPacket::handler);
        NetworkHandler.register(ServerBoundRequestMapDataPacket.class, ServerBoundRequestMapDataPacket::buffer, ServerBoundRequestMapDataPacket::new, ServerBoundRequestMapDataPacket::handler);
        NetworkHandler.register(ServerBoundSetBlackboardPacket.class, ServerBoundSetBlackboardPacket::buffer, ServerBoundSetBlackboardPacket::new, ServerBoundSetBlackboardPacket::handler);
        NetworkHandler.register(ServerBoundCycleQuiverPacket.class, ServerBoundCycleQuiverPacket::buffer, ServerBoundCycleQuiverPacket::new, ServerBoundCycleQuiverPacket::handler);
        NetworkHandler.register(SyncConfigsPacket.class, SyncConfigsPacket::buffer, SyncConfigsPacket::new, SyncConfigsPacket::handler);
        NetworkHandler.register(ClientBoundSendLoginPacket.class, ClientBoundSendLoginPacket::buffer, ClientBoundSendLoginPacket::new, ClientBoundSendLoginPacket::handler);
        NetworkHandler.register(OpenConfigsPacket.class, OpenConfigsPacket::buffer, OpenConfigsPacket::new, OpenConfigsPacket::handler);
        NetworkHandler.register(RequestConfigReloadPacket.class, RequestConfigReloadPacket::buffer, RequestConfigReloadPacket::new, RequestConfigReloadPacket::handler);
        NetworkHandler.register(PicklePacket.class, PicklePacket::buffer, PicklePacket::new, PicklePacket::handler);
        NetworkHandler.register(ClientBoundSyncTradesPacket.class, ClientBoundSyncTradesPacket::buffer, ClientBoundSyncTradesPacket::new, ClientBoundSyncTradesPacket::handler);
        NetworkHandler.register(ServerBoundSetPresentPacket.class, ServerBoundSetPresentPacket::buffer, ServerBoundSetPresentPacket::new, ServerBoundSetPresentPacket::handler);
        NetworkHandler.register(ServerBoundSetTrappedPresentPacket.class, ServerBoundSetTrappedPresentPacket::buffer, ServerBoundSetTrappedPresentPacket::new, ServerBoundSetTrappedPresentPacket::handler);
        NetworkHandler.register(ClientBoundSendKnockbackPacket.class, ClientBoundSendKnockbackPacket::buffer, ClientBoundSendKnockbackPacket::new, ClientBoundSendKnockbackPacket::handler);
        NetworkHandler.register(ServerBoundSelectMerchantTradePacket.class, ServerBoundSelectMerchantTradePacket::buffer, ServerBoundSelectMerchantTradePacket::new, ServerBoundSelectMerchantTradePacket::handler);
        NetworkHandler.register(ClientBoundSyncAntiqueInk.class, ClientBoundSyncAntiqueInk::buffer, ClientBoundSyncAntiqueInk::new, ClientBoundSyncAntiqueInk::handler);
        NetworkHandler.register(ClientBoundSyncSongsPacket.class, ClientBoundSyncSongsPacket::buffer, ClientBoundSyncSongsPacket::new, ClientBoundSyncSongsPacket::handler);
        NetworkHandler.register(ClientBoundSetSongPacket.class, ClientBoundSetSongPacket::buffer, ClientBoundSetSongPacket::new, ClientBoundSetSongPacket::handler);
        NetworkHandler.register(ClientBoundSpawnBlockParticlePacket.class, ClientBoundSpawnBlockParticlePacket::buffer, ClientBoundSpawnBlockParticlePacket::new, ClientBoundSpawnBlockParticlePacket::handler);
        NetworkHandler.register(ClientBoundOpenScreenPacket.class, ClientBoundOpenScreenPacket::buffer, ClientBoundOpenScreenPacket::new, ClientBoundOpenScreenPacket::handler);
        NetworkHandler.register(ClientBoundPlaySongNotesPacket.class, ClientBoundPlaySongNotesPacket::buffer, ClientBoundPlaySongNotesPacket::new, ClientBoundPlaySongNotesPacket::handler);
    }

    public static void sendToAllTrackingClients(Entity entity2, ServerLevel world, Message message) {
        world.m_7726_().m_8445_(entity2, INSTANCE.toVanillaPacket((Object)message, NetworkDirection.PLAY_TO_CLIENT));
    }

    public static void sendToAllInRangeClients(BlockPos pos, ServerLevel level, double distance, Message message) {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer != null) {
            PlayerList players = currentServer.m_6846_();
            ResourceKey dimension = level.m_46472_();
            players.m_11241_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), distance, dimension, INSTANCE.toVanillaPacket((Object)message, NetworkDirection.PLAY_TO_CLIENT));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServerPlayer(Message message) {
        Minecraft.m_91087_().m_91403_().m_104955_(INSTANCE.toVanillaPacket((Object)message, NetworkDirection.PLAY_TO_SERVER));
    }

    static {
        ID = 0;
    }

    public static interface Message {
    }
}

